// Additional B2B validation utilities
function extractCompanyName() {
  // Try multiple sources
  const sources = [
    document.querySelector('meta[property="og:site_name"]')?.content,
    document.querySelector('meta[name="application-name"]')?.content,
    document.querySelector('h1')?.textContent,
    document.title.split('|')[0].split('-')[0].trim()
  ];
  
  return sources.find(s => s && s.length > 0 && s.length < 100) || 'Unknown';
}

function extractIndustryKeywords() {
  const keywords = {
    medical: ['clinic', 'hospital', 'doctor', 'medical', 'health', 'pharmacy', 'лікарня', 'клініка', 'аптека'],
    beauty: ['salon', 'spa', 'beauty', 'cosmetic', 'barbershop', 'салон', 'барбершоп'],
    restaurant: ['restaurant', 'cafe', 'bistro', 'menu', 'food', 'ресторан', 'кафе', 'меню'],
    hotel: ['hotel', 'resort', 'accommodation', 'booking', 'готель', 'бронювання'],
    construction: ['construction', 'builder', 'contractor', 'renovation', 'будівництво', 'ремонт'],
    retail: ['shop', 'store', 'retail', 'магазин', 'крамниця'],
    legal: ['law', 'lawyer', 'attorney', 'legal', 'адвокат', 'юрист']
  };
  
  const pageText = document.body.innerText.toLowerCase();
  const metaKeywords = document.querySelector('meta[name="keywords"]')?.content?.toLowerCase() || '';
  const description = document.querySelector('meta[name="description"]')?.content?.toLowerCase() || '';
  
  const combinedText = `${pageText} ${metaKeywords} ${description}`;
  
  const matches = [];
  for (const [industry, words] of Object.entries(keywords)) {
    const matchCount = words.filter(word => combinedText.includes(word)).length;
    if (matchCount > 0) {
      matches.push({ industry, score: matchCount });
    }
  }
  
  matches.sort((a, b) => b.score - a.score);
  return matches.length > 0 ? matches[0].industry : 'other';
}

function extractAddresses() {
  const addresses = [];
  
  // Schema.org structured data
  document.querySelectorAll('[itemprop="address"]').forEach(el => {
    addresses.push(el.textContent.trim());
  });
  
  // Common address patterns
  const text = document.body.innerText;
  const addressPattern = /(street|st\.|avenue|ave\.|road|rd\.|вул\.|вулиця|проспект)[^\n]{5,100}/gi;
  const matches = text.match(addressPattern) || [];
  addresses.push(...matches);
  
  return [...new Set(addresses)].filter(addr => addr.length > 10 && addr.length < 200);
}

function extractSocialLinks() {
  const social = {
    facebook: null,
    instagram: null,
    linkedin: null,
    twitter: null
  };
  
  document.querySelectorAll('a[href*="facebook.com"]').forEach(a => {
    if (!social.facebook) social.facebook = a.href;
  });
  
  document.querySelectorAll('a[href*="instagram.com"]').forEach(a => {
    if (!social.instagram) social.instagram = a.href;
  });
  
  document.querySelectorAll('a[href*="linkedin.com"]').forEach(a => {
    if (!social.linkedin) social.linkedin = a.href;
  });
  
  document.querySelectorAll('a[href*="twitter.com"], a[href*="x.com"]').forEach(a => {
    if (!social.twitter) social.twitter = a.href;
  });
  
  return social;
}

