# Інструкція встановлення Chrome розширення

## Крок 1: Відкрийте Chrome Extensions

1. Відкрийте Chrome/Chromium
2. Перейдіть на `chrome://extensions/`
3. Увімкніть **"Режим розробника"** (Developer mode) у верхньому правому куті

## Крок 2: Завантажте розширення

1. Натисніть **"Завантажити розпаковане"** (Load unpacked)
2. Виберіть папку: `/home/dchuprina/desktopskrap/chrome-extension`
3. Розширення має з'явитися у списку

## Типові помилки та рішення

### ❌ "Manifest file is missing or unreadable"
**Рішення:** Переконайтеся, що ви вибрали саме папку `chrome-extension`, а не папку вище чи нижче

### ❌ "Could not load icon"
**Рішення:** Згенеруйте іконки:
```bash
cd /home/dchuprina/desktopskrap/chrome-extension
python3 generate_icons.py
```

### ❌ "Service worker registration failed"
**Рішення:** Перевірте консоль помилок:
1. На сторінці `chrome://extensions/`
2. Знайдіть розширення
3. Натисніть "Errors" або "Помилки"
4. Скопіюйте та надішліть помилку

### ❌ Розширення завантажилося, але не працює
**Причини:**
1. Desktop app не запущений (має працювати на `http://localhost:8765`)
2. Перевірте статус підключення у popup розширення
3. Відкрийте Console у popup (ПКМ → Inspect → Console)

## Крок 3: Перевірка роботи

1. Натисніть на іконку розширення у toolbar
2. Має показати:
   - ✅ "Connected to Desktop App" (якщо desktop app запущений)
   - ❌ "Desktop App not running" (якщо не запущений)

## Як отримати логи помилок:

### 1. Помилки background script:
```
chrome://extensions/ → Знайдіть розширення → "Service Worker" → Console
```

### 2. Помилки popup:
```
ПКМ на іконці розширення → Inspect → Console
```

### 3. Помилки content script:
```
F12 на будь-якій веб-сторінці → Console
```

## Якщо нічого не допомагає:

1. Видаліть розширення з Chrome
2. Перезапустіть Chrome
3. Завантажте розширення знову
4. Надішліть скріншот помилки з Console

## Перевірка manifest.json:

```bash
cd /home/dchuprina/desktopskrap/chrome-extension
cat manifest.json | python3 -m json.tool
```

Якщо команда повертає помилку → JSON невалідний, треба виправити.

