// Extract emails with B2B validation
function extractEmails() {
  const text = document.body.innerText;
  const emailRegex = /[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/g;
  const emails = text.match(emailRegex) || [];
  
  // Also check mailto: links
  const mailtoLinks = Array.from(document.querySelectorAll('a[href^="mailto:"]'))
    .map(link => link.href.replace('mailto:', '').split('?')[0]);
  
  const allEmails = [...new Set([...emails, ...mailtoLinks])];
  
  // Filter out personal email domains (B2B only)
  const personalDomains = [
    'gmail.com', 'yahoo.com', 'hotmail.com', 'outlook.com',
    'aol.com', 'icloud.com', 'live.com', 'msn.com',
    'mail.ru', 'yandex.ru', 'protonmail.com', 'tutanota.com',
    'gmx.com', 'zoho.com', 'fastmail.com'
  ];
  
  return allEmails.filter(email => {
    const domain = email.split('@')[1]?.toLowerCase();
    return domain && !personalDomains.includes(domain);
  });
}

